/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.renderer.GraphicsUtil;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class MaskedPaint
implements Paint,
GraphicsUtil.WrappingPaint {
    @NotNull
    private Paint paint;
    @NotNull
    private final Raster maskRaster;
    @NotNull
    private final Point maskOffset;

    public MaskedPaint(@NotNull Paint paint, @NotNull Raster maskRaster, @NotNull Point2D maskOffset) {
        this.paint = paint;
        this.maskRaster = maskRaster;
        this.maskOffset = new Point((int)Math.floor(maskOffset.getX()), (int)Math.floor(maskOffset.getY()));
    }

    @Override
    public void setPaint(@NotNull Paint paint) {
        this.paint = GraphicsUtil.setupPaint(this.paint, paint);
    }

    @Override
    public PaintContext createContext(ColorModel cm2, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        PaintContext parentContext = this.paint.createContext(null, deviceBounds, userBounds, xform, hints);
        return new MaskPaintContext(parentContext, this.maskRaster, this.maskOffset);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private static final class MaskPaintContext
    implements PaintContext {
        @NotNull
        private final PaintContext parentContext;
        @NotNull
        private final ColorModel colorModel;
        private final int numColorComponents;
        @NotNull
        private final ColorModel parentColorModel;
        @NotNull
        private final Raster maskRaster;
        @NotNull
        private final Point offset;

        MaskPaintContext(@NotNull PaintContext parentContext, @NotNull Raster maskRaster, @NotNull Point offset) {
            this.parentContext = parentContext;
            this.parentColorModel = parentContext.getColorModel();
            this.maskRaster = maskRaster;
            this.offset = offset;
            this.colorModel = parentContext.getColorModel().hasAlpha() ? this.parentColorModel : new ComponentColorModel(parentContext.getColorModel().getColorSpace(), true, false, 1, 0);
            this.numColorComponents = this.colorModel.getNumColorComponents();
        }

        @Override
        @NotNull
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public void dispose() {
            this.parentContext.dispose();
        }

        @Override
        public Raster getRaster(int x2, int y2, int w2, int h2) {
            WritableRaster result;
            Raster parentRaster = this.parentContext.getRaster(x2, y2, w2, h2);
            int parentMinX = parentRaster.getMinX();
            int parentMinY = parentRaster.getMinY();
            if (parentRaster instanceof WritableRaster) {
                if (this.parentColorModel.equals(this.colorModel)) {
                    result = parentRaster.createCompatibleWritableRaster();
                    result.setDataElements(-parentMinX, -parentMinY, parentRaster);
                } else {
                    BufferedImage parentImage = new BufferedImage(this.parentColorModel, (WritableRaster)parentRaster, this.parentColorModel.isAlphaPremultiplied(), null);
                    result = Raster.createWritableRaster(this.colorModel.createCompatibleSampleModel(w2, h2), new Point(0, 0));
                    BufferedImage resultImage = new BufferedImage(this.colorModel, result, false, null);
                    Graphics graphics = resultImage.getGraphics();
                    graphics.drawImage(parentImage, 0, 0, null);
                    graphics.dispose();
                }
            } else {
                result = Raster.createInterleavedRaster(0, w2, h2, this.getColorModel().getNumComponents(), new Point(0, 0));
                ColorConvertOp colorConvertOp = new ColorConvertOp(this.parentColorModel.getColorSpace(), this.colorModel.getColorSpace(), null);
                colorConvertOp.filter(parentRaster, result);
            }
            int softMaskMinX = this.maskRaster.getMinX();
            int softMaskMinY = this.maskRaster.getMinY();
            int softMaskMaxX = softMaskMinX + this.maskRaster.getWidth();
            int softMaskMaxY = softMaskMinY + this.maskRaster.getHeight();
            for (int j2 = 0; j2 < h2; ++j2) {
                for (int i2 = 0; i2 < w2; ++i2) {
                    int rx = x2 + i2 - this.offset.x;
                    int ry = y2 + j2 - this.offset.y;
                    int alpha = rx >= softMaskMinX && rx < softMaskMaxX && ry >= softMaskMinY && ry < softMaskMaxY ? this.maskRaster.getSample(rx, ry, 0) : 0;
                    alpha = alpha * result.getSample(i2, j2, this.numColorComponents) / 255;
                    result.setSample(i2, j2, this.numColorComponents, alpha);
                }
            }
            return result;
        }
    }
}

